#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float amount; // bend amount

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec2 uv;

#define PI 3.1415926535897932384626433832795

vec3 deform_vertex(in vec3 pos)
{
	const float radius = 44.0;
	vec3 center = vec3(0.0, 0.0, 44.0*(1.0 - amount));
	vec3 p = pos - center;
	float angle = 2.0*6.28*amount;

	float r = radius / angle;
	if ( angle < 0.0001 || r < 0.00001 )
	{
		return pos;
	}
	else
	{
		float y = p.y;
		float z = p.z;
		float zr = (z / r);
		float c = cos(PI - zr);
		float s = sin(PI - zr);
		p.y = r*c + r - c*y;
		p.z = r*s - y*s;

		return p + center;
	}
}


void main()
{
	const float delta = 1.0 / 30.0;

	vec3 t = cross(NORMAL, vec3(0.0, 0.0, 1.0));
	vec3 b = cross(NORMAL, vec3(0.0, 1.0, 0.0));
	if ( dot(b,b) > dot(t,t) ) t = b;
	b = cross(NORMAL, t);

	vec3 dt = deform_vertex(POSITION + t*delta);
	vec3 db = deform_vertex(POSITION + b*delta);

	normal = NormalMatrix * cross(db, dt);
	vec3 pos = deform_vertex(POSITION);

	//
	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;
	ec_pos = vec3(ModelViewMatrix * vec4(pos, 1.0));
	vec4 proj_pos = ModelViewProjectionMatrix * vec4(pos, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
